import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file

atp_tennis = read_csv_file('atp_tennis.csv')

def estimate_probability(player_1_win_rate, player_2_win_rate, h2h_player_1_win_rate, h2h_player_2_win_rate, performance_weight=0.7, h2h_weight=0.3):
    if player_1_win_rate + player_2_win_rate == 0:
        player_1_win_rate = player_2_win_rate = 0.5

    if h2h_player_1_win_rate + h2h_player_2_win_rate == 0:
        h2h_player_1_win_rate = h2h_player_2_win_rate = 0.5

    weighted_player_1_win_rate = performance_weight * player_1_win_rate + h2h_weight * h2h_player_1_win_rate
    weighted_player_2_win_rate = performance_weight * player_2_win_rate + h2h_weight * h2h_player_2_win_rate
    total_weighted_win_rate = weighted_player_1_win_rate + weighted_player_2_win_rate

    player_1_probability = weighted_player_1_win_rate / total_weighted_win_rate
    player_2_probability = weighted_player_2_win_rate / total_weighted_win_rate

    return player_1_probability, player_2_probability